/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.mixin;

import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.dimension.AtlantisDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Player.class})
public abstract class CanBreatheInDimension
extends LivingEntity {
    protected CanBreatheInDimension(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Unique
    public boolean canBreatheUnderwater() {
        if (((Boolean)AtlantisConfig.CONFIG.turnOnDimensionalWaterBreathing.get()).booleanValue()) {
            if (this.level().dimension() == AtlantisDimensions.ATLANTIS_WORLD) {
                return true;
            }
            return super.canBreatheUnderwater();
        }
        return super.canBreatheUnderwater();
    }

    @Unique
    protected void tickWaterBreathingAir(int air) {
        if (((Boolean)AtlantisConfig.CONFIG.turnOnDimensionalWaterBreathing.get()).booleanValue() && this.level().dimension() == AtlantisDimensions.ATLANTIS_WORLD) {
            this.setAirSupply(this.increaseAirSupply(air));
        }
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        this.tickWaterBreathingAir(i);
    }
}

