/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.mixin;

import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.dimension.AtlantisDimensions;
import java.util.Objects;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class ChangeBreakSpeedMixin
extends LivingEntity {
    @Shadow
    @Final
    private Inventory inventory;

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    protected ChangeBreakSpeedMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"getDestroySpeed"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBlockBreakingSpeed(BlockState block, CallbackInfoReturnable<Float> cir) {
        if (((Boolean)AtlantisConfig.CONFIG.turnOnDimensionalHaste.get()).booleanValue()) {
            cir.cancel();
            float f = this.inventory.getDestroySpeed(block);
            if (f > 1.0f) {
                float i = block.getBlock().getSpeedFactor();
                ItemStack itemStack = this.getMainHandItem();
                if (i > 0.0f && !itemStack.isEmpty()) {
                    f += i * i + 1.0f;
                }
            }
            if (MobEffectUtil.hasDigSpeed((LivingEntity)this)) {
                f *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification((LivingEntity)this) + 1) * 0.2f;
            }
            if (this.hasEffect(MobEffects.DIG_SLOWDOWN)) {
                float k = switch (Objects.requireNonNull(this.getEffect(MobEffects.DIG_SLOWDOWN)).getAmplifier()) {
                    case 0 -> 0.3f;
                    case 1 -> 0.09f;
                    case 2 -> 0.0027f;
                    default -> 8.1E-4f;
                };
                f *= k;
            }
            if (this.level().dimension() == AtlantisDimensions.ATLANTIS_WORLD && !this.onGround() && !this.isEyeInFluid(FluidTags.WATER)) {
                f /= 5.0f;
            }
            cir.setReturnValue((Object)Float.valueOf(f));
        }
    }
}

