/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.mixin;

import com.mystic.atlantis.datagen.EnchantmentInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentMenu.class})
public class EnchantmentMenuMixin {
    @Shadow
    @Final
    private ContainerLevelAccess access;
    @Shadow
    @Final
    private RandomSource random;

    @Inject(method={"getEnchantmentList"}, at={@At(value="HEAD")}, cancellable=true)
    private void atlantis$injectAquaticEnchantments(RegistryAccess registryAccess, ItemStack stack, int slot, int cost, CallbackInfoReturnable<List<EnchantmentInstance>> cir) {
        if (!stack.isEnchantable()) {
            return;
        }
        AtomicInteger fishCount = new AtomicInteger();
        Optional result = this.access.evaluate((level, pos) -> {
            fishCount.set(level.getEntitiesOfClass(AbstractFish.class, new AABB(pos).inflate(4.0)).size());
            if (fishCount.get() < 8) {
                Optional vanillaTag = registryAccess.registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.IN_ENCHANTING_TABLE);
                if (vanillaTag.isPresent()) {
                    this.random.setSeed((long)(slot + this.random.nextInt()));
                    List result2 = EnchantmentHelper.selectEnchantment((RandomSource)this.random, (ItemStack)stack, (int)cost, (Stream)((HolderSet.Named)vanillaTag.get()).stream());
                    if (stack.is(Items.BOOK) && result2.size() > 1) {
                        result2.remove(this.random.nextInt(result2.size()));
                    }
                    return result2;
                }
                return Collections.emptyList();
            }
            int enchantLevel = fishCount.get() >= 24 ? 3 : (fishCount.get() >= 16 ? 2 : 1);
            ArrayList<EnchantmentInstance> aquatic = new ArrayList<EnchantmentInstance>();
            this.atlantis$addIfApplicable((List<EnchantmentInstance>)aquatic, stack, (Level)level, EnchantmentInit.DEPTH_PULSE, enchantLevel);
            this.atlantis$addIfApplicable((List<EnchantmentInstance>)aquatic, stack, (Level)level, EnchantmentInit.TIDE_CALL, enchantLevel);
            this.atlantis$addIfApplicable((List<EnchantmentInstance>)aquatic, stack, (Level)level, EnchantmentInit.REEL_BIND, enchantLevel);
            this.atlantis$addIfApplicable((List<EnchantmentInstance>)aquatic, stack, (Level)level, EnchantmentInit.CURRENT_GLIDE, enchantLevel);
            this.atlantis$addIfApplicable((List<EnchantmentInstance>)aquatic, stack, (Level)level, EnchantmentInit.ABYSSAL_ARMOR, enchantLevel);
            this.atlantis$addIfApplicable((List<EnchantmentInstance>)aquatic, stack, (Level)level, EnchantmentInit.GILL_BREATH, enchantLevel);
            this.atlantis$addIfApplicable((List<EnchantmentInstance>)aquatic, stack, (Level)level, EnchantmentInit.ABYSS_WALKER, enchantLevel);
            return aquatic;
        });
        result.ifPresent(list -> {
            if (fishCount.get() >= 8) {
                if (!list.isEmpty()) {
                    EnchantmentInstance chosen = (EnchantmentInstance)list.get(this.random.nextInt(list.size()));
                    cir.setReturnValue(List.of(chosen));
                } else {
                    cir.setReturnValue(Collections.emptyList());
                }
            }
        });
    }

    @Unique
    private void atlantis$addIfApplicable(List<EnchantmentInstance> list, ItemStack stack, Level level, ResourceKey<Enchantment> enchant, int levelVal) {
        Holder.Reference<Enchantment> holder = EnchantmentInit.getEnchantmentHolder(level, enchant);
        if (stack.isPrimaryItemFor(holder)) {
            list.add(new EnchantmentInstance(holder, levelVal));
        }
    }
}

