/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.mixin;

import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.mixin.RedstoneAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RedStoneWireBlock.class}, priority=99999)
public abstract class RedstoneWireBlockMixin {
    @Redirect(method={"shouldConnectTo(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z", ordinal=0))
    private static boolean is(BlockState state, Block block) {
        return state.is(block) || state.is((Block)BlockInit.AQUATIC_POWER_DUST_WIRE.get());
    }

    @Unique
    private int atlantis$getWireSignal(BlockState state) {
        if (state.is(Blocks.REDSTONE_WIRE)) {
            return (Integer)state.getValue((Property)RedStoneWireBlock.POWER);
        }
        if (state.is((Block)BlockInit.AQUATIC_POWER_DUST_WIRE.get())) {
            return (Integer)state.getValue((Property)RedStoneWireBlock.POWER);
        }
        return 0;
    }

    @Inject(method={"calculateTargetStrength"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void setPowerToWires1(Level level, BlockPos targetPos, CallbackInfoReturnable<Integer> cir) {
        cir.cancel();
        ((RedstoneAccessor)((RedStoneWireBlock)this)).setShouldSignal(false);
        int receivedPower = level.getBestNeighborSignal(targetPos);
        ((RedstoneAccessor)((RedStoneWireBlock)this)).setShouldSignal(true);
        int calculatedPower = 0;
        if (receivedPower >= 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (level.getBlockState(targetPos.relative(direction)).getBlockHolder().value() != BlockInit.AQUATIC_POWER_DUST_WIRE.get() && level.getBlockState(targetPos.relative(direction).below()).getBlockHolder().value() != BlockInit.AQUATIC_POWER_DUST_WIRE.get() && level.getBlockState(targetPos.relative(direction).above()).getBlockHolder().value() != BlockInit.AQUATIC_POWER_DUST_WIRE.get()) continue;
                cir.setReturnValue((Object)Math.max(receivedPower - 1, calculatedPower - 1));
            }
            cir.setReturnValue((Object)receivedPower);
        } else if (receivedPower >= 0) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos relativePos = targetPos.relative(direction);
                BlockState relativeState = level.getBlockState(relativePos);
                calculatedPower = Math.max(calculatedPower, this.atlantis$getWireSignal(relativeState));
                BlockPos aboveTargetPos = targetPos.above();
                if (relativeState.isRedstoneConductor((BlockGetter)level, relativePos) && !level.getBlockState(aboveTargetPos).isRedstoneConductor((BlockGetter)level, aboveTargetPos)) {
                    calculatedPower = Math.max(calculatedPower, this.atlantis$getWireSignal(level.getBlockState(relativePos.above())));
                    continue;
                }
                if (relativeState.isRedstoneConductor((BlockGetter)level, relativePos)) continue;
                calculatedPower = Math.max(calculatedPower, this.atlantis$getWireSignal(level.getBlockState(relativePos.below())));
            }
            if (receivedPower == 0) {
                cir.setReturnValue((Object)Math.max(receivedPower, calculatedPower - 1));
            } else {
                cir.setReturnValue((Object)Math.max(receivedPower - 1, calculatedPower - 1));
            }
        } else {
            cir.setReturnValue((Object)0);
        }
    }
}

