/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.blocks.base.EquipableCarvedCoconut;
import com.mystic.atlantis.init.BlockInit;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OverlayEventHandler
implements LayeredDraw.Layer {
    public static final ResourceLocation COCONUT_BLUR = Atlantis.id("textures/misc/coconutblur.png");
    private static final Minecraft minecraft = Minecraft.getInstance();

    public void renderCoconutBlur(GuiGraphics stack) {
        ItemStack itemstack;
        if (OverlayEventHandler.minecraft.player != null && OverlayEventHandler.minecraft.options.getCameraType().isFirstPerson() && !OverlayEventHandler.minecraft.player.isScoping() && (itemstack = OverlayEventHandler.minecraft.player.getInventory().getArmor(3)).is(((EquipableCarvedCoconut)((Object)BlockInit.CARVED_COCONUT.get())).asItem())) {
            Screen screen = Minecraft.getInstance().screen;
            OverlayEventHandler.renderTextureOverlay(stack, COCONUT_BLUR, 1.0f, screen.width, screen.height);
        }
    }

    public static void renderTextureOverlay(GuiGraphics pGuiGraphics, ResourceLocation pShaderLocation, float pAlpha, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, pAlpha);
        pGuiGraphics.blit(pShaderLocation, 0, 0, -90, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(GuiGraphics p_316811_, DeltaTracker p_348559_) {
        this.renderCoconutBlur(p_316811_);
    }
}

