/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class PushBubbleStreamParticleNorth
extends TextureSheetParticle {
    private final Direction direction;

    PushBubbleStreamParticleNorth(ClientLevel clientWorld, double x, double y, double z, Direction direction) {
        super(clientWorld, x, y, z);
        this.direction = direction;
        this.lifetime = (int)(40.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        Vector3f vec = direction.step();
        this.xd = (double)vec.x() * 0.2 + (Math.random() * 0.02 - 0.01);
        this.yd = (double)vec.y() * 0.2 + (Math.random() * 0.02 - 0.01);
        this.zd = (double)vec.z() * 0.2 + (Math.random() * 0.02 - 0.01);
        this.setSize(0.02f, 0.02f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.2f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            Vector3f vec = this.direction.step();
            float speedFactor = 0.02f;
            this.xd = vec.x() * speedFactor;
            this.yd = vec.y() * speedFactor;
            this.zd = vec.z() * speedFactor;
            this.move(this.xd, this.yd, this.zd);
            if (!this.level.getFluidState(new BlockPos((int)this.x, (int)this.y, (int)this.z)).is(FluidTags.WATER)) {
                this.remove();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            PushBubbleStreamParticleNorth pushBubbleStreamParticle = new PushBubbleStreamParticleNorth(clientWorld, d, e, f, Direction.NORTH);
            pushBubbleStreamParticle.pickSprite(this.spriteProvider);
            return pushBubbleStreamParticle;
        }
    }
}

