/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.init.GlyphBlock;
import com.mystic.atlantis.inventory.LinguisticMenu;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;

public class LinguisticScreen
extends AbstractContainerScreen<LinguisticMenu> {
    private static final ResourceLocation BG_LOCATION = Atlantis.id("textures/gui/container/linguistic.png");
    private static final Map<DyeColor, Color> colorMap = Stream.of(DyeColor.values()).collect(Collectors.toMap(a -> a, a -> new Color(a.getTextureDiffuseColor())));
    private static final Color defaultColor = new Color(FastColor.ARGB32.opaque((int)9219794));

    public LinguisticScreen(LinguisticMenu arg, Inventory arg2, Component arg3) {
        super((AbstractContainerMenu)arg, arg2, arg3);
        this.imageWidth = 184;
        this.imageHeight = 174;
        this.titleLabelX = 10;
        this.titleLabelY = 8;
        this.inventoryLabelX = 12;
        this.inventoryLabelY = this.imageHeight - 98;
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics arg, int i, int j, float f) {
        super.render(arg, i, j, f);
        this.renderTooltip(arg, i, j);
    }

    protected void renderBg(GuiGraphics arg, float f, int i, int j) {
        BlockItem item;
        Item item2;
        int k = this.leftPos;
        int l = this.topPos;
        arg.blit(BG_LOCATION, k, l, 0, 0, this.imageWidth, this.imageHeight);
        Slot slot = ((LinguisticMenu)this.menu).getBlankSlot();
        Slot slot2 = ((LinguisticMenu)this.menu).getDyeSlot();
        Slot slot3 = ((LinguisticMenu)this.menu).getSymbolSlot();
        Slot slot4 = ((LinguisticMenu)this.menu).getResultSlot();
        if (!slot.hasItem()) {
            arg.blit(BG_LOCATION, k + slot.x, l + slot.y, this.imageWidth, 0, 16, 16);
        }
        if (!slot2.hasItem()) {
            arg.blit(BG_LOCATION, k + slot2.x, l + slot2.y, this.imageWidth + 16, 0, 16, 16);
        }
        if (!slot3.hasItem()) {
            arg.blit(BG_LOCATION, k + slot3.x, l + slot3.y, this.imageWidth + 32, 0, 16, 16);
        }
        if (slot4.hasItem() && (item2 = slot4.getItem().getItem()) instanceof BlockItem && (item2 = (item = (BlockItem)item2).getBlock()) instanceof GlyphBlock) {
            GlyphBlock glyphBlock = (GlyphBlock)item2;
            arg.pose().pushPose();
            arg.pose().translate((float)(k + 74), (float)(l + 29), 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            Color color = colorMap.get(glyphBlock.getDyeColor());
            Objects.requireNonNullElse(color, defaultColor).setup();
            arg.blit(glyphBlock.getGlyph().getTexture(), 0, 0, 34, 34, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            arg.pose().popPose();
        }
    }

    private record Color(float r, float g, float b) {
        public Color(float[] color) {
            this(color[0], color[1], color[2]);
        }

        public Color(int color) {
            this((float)FastColor.ARGB32.red((int)color) / 255.0f, (float)FastColor.ARGB32.green((int)color) / 255.0f, (float)FastColor.ARGB32.blue((int)color) / 255.0f);
        }

        public void setup() {
            RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)1.0f);
        }
    }
}

