/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.blocks.base.LinguisticGlyph;
import com.mystic.atlantis.init.ItemInit;
import com.mystic.atlantis.inventory.WritingMenu;
import com.mystic.atlantis.recipes.WritingRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;

public class WritingScreen
extends AbstractContainerScreen<WritingMenu> {
    private static final ResourceLocation BG_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/stonecutter.png");
    private static final ResourceLocation GRADIENT = Atlantis.id("textures/gui/container/gradient.png");
    private static final ResourceLocation GRADIENT_TOP = Atlantis.id("textures/gui/container/gradient_top.png");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 52;
    private static final int RECIPES_Y = 14;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public WritingScreen(WritingMenu arg, Inventory arg2, Component arg3) {
        super((AbstractContainerMenu)arg, arg2, arg3);
        arg.registerUpdateListener(this::containerChanged);
    }

    public void render(GuiGraphics poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(poseStack, mouseX, mouseY, partialTick);
        this.renderTooltip(poseStack, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.leftPos;
        int j = this.topPos;
        poseStack.blit(BG_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int k = (int)(41.0f * this.scrollOffs);
        poseStack.blit(BG_LOCATION, i + 119, j + 15 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.leftPos + 52;
        int m = this.topPos + 14;
        int n = this.startIndex + 12;
        this.renderButtons(poseStack, mouseX, mouseY, l, m, n);
        this.renderRecipes(poseStack, l, m, n);
        poseStack.blit(GRADIENT_TOP, i - 4, j - 4, 0, 0, this.imageWidth + 7, this.imageHeight + 7);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.blit(GRADIENT, i - 4, j - 4, 0, 0, this.imageWidth + 7, this.imageHeight + 7);
        RenderSystem.disableBlend();
    }

    protected void renderTooltip(GuiGraphics poseStack, int x, int y) {
        super.renderTooltip(poseStack, x, y);
        if (this.displayRecipes) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.startIndex + 12;
            List<RecipeHolder<WritingRecipe>> list = ((WritingMenu)this.menu).getRecipes();
            for (int l = this.startIndex; l < k && l < ((WritingMenu)this.menu).getNumRecipes(); ++l) {
                int m = l - this.startIndex;
                int n = i + m % 4 * 16;
                int o = j + m / 4 * 18 + 2;
                if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
                assert (Minecraft.getInstance().level != null);
                poseStack.renderTooltip(this.font, ((WritingRecipe)list.get(l).value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), x, y);
            }
        }
    }

    private void renderButtons(GuiGraphics poseStack, int mouseX, int mouseY, int x, int y, int lastVisibleElementIndex) {
        for (int i = this.startIndex; i < lastVisibleElementIndex && i < ((WritingMenu)this.menu).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            int n = this.imageHeight;
            if (i == ((WritingMenu)this.menu).getSelectedRecipeIndex()) {
                n += 18;
            } else if (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18) {
                n += 36;
            }
            poseStack.blit(BG_LOCATION, k, m - 1, 0, n, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int left, int top, int recipeIndexOffsetMax) {
        List<RecipeHolder<WritingRecipe>> list = ((WritingMenu)this.menu).getRecipes();
        for (int i = this.startIndex; i < recipeIndexOffsetMax && i < ((WritingMenu)this.menu).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int m = top + l * 18 + 2;
            guiGraphics.renderFakeItem(((Item)ItemInit.getScroll(WritingScreen.intToGlyph(i)).get()).getDefaultInstance(), k, m);
        }
    }

    public static LinguisticGlyph intToGlyph(int scroll) {
        return switch (scroll) {
            case 1 -> LinguisticGlyph.ZERO;
            case 2 -> LinguisticGlyph.ONE;
            case 3 -> LinguisticGlyph.TWO;
            case 4 -> LinguisticGlyph.THREE;
            case 5 -> LinguisticGlyph.FOUR;
            case 6 -> LinguisticGlyph.FIVE;
            case 7 -> LinguisticGlyph.SIX;
            case 8 -> LinguisticGlyph.SEVEN;
            case 9 -> LinguisticGlyph.EIGHT;
            case 10 -> LinguisticGlyph.NINE;
            case 11 -> LinguisticGlyph.A;
            case 12 -> LinguisticGlyph.B;
            case 13 -> LinguisticGlyph.C;
            case 14 -> LinguisticGlyph.D;
            case 15 -> LinguisticGlyph.E;
            case 16 -> LinguisticGlyph.F;
            case 17 -> LinguisticGlyph.G;
            case 18 -> LinguisticGlyph.H;
            case 19 -> LinguisticGlyph.I;
            case 20 -> LinguisticGlyph.J;
            case 21 -> LinguisticGlyph.K;
            case 22 -> LinguisticGlyph.L;
            case 23 -> LinguisticGlyph.M;
            case 24 -> LinguisticGlyph.N;
            case 25 -> LinguisticGlyph.O;
            case 26 -> LinguisticGlyph.P;
            case 27 -> LinguisticGlyph.Q;
            case 28 -> LinguisticGlyph.R;
            case 29 -> LinguisticGlyph.S;
            case 30 -> LinguisticGlyph.T;
            case 31 -> LinguisticGlyph.U;
            case 32 -> LinguisticGlyph.V;
            case 33 -> LinguisticGlyph.W;
            case 34 -> LinguisticGlyph.X;
            case 35 -> LinguisticGlyph.Y;
            case 36 -> LinguisticGlyph.Z;
            default -> LinguisticGlyph.BLANK;
        };
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int m = l - this.startIndex;
                double d = mouseX - (double)(i + m % 4 * 16);
                double e = mouseY - (double)(j + m / 4 * 18);
                if (!(d >= 0.0 && e >= 0.0 && d < 16.0 && e < 18.0 && ((WritingMenu)this.menu).clickMenuButton((Player)this.minecraft.player, l))) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((WritingMenu)this.menu).containerId, l);
                return true;
            }
            i = this.leftPos + 119;
            j = this.topPos + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 14;
            int j = i + 54;
            this.scrollOffs = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pScrollY / (double)i);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((WritingMenu)this.menu).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((WritingMenu)this.menu).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((WritingMenu)this.menu).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

