/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.client;

import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.CompassState;
import com.chaosthedude.naturescompass.util.ItemUtils;
import com.chaosthedude.naturescompass.util.RenderUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NaturesCompassOverlay
implements LayeredDraw.Layer {
    public static final Minecraft mc = Minecraft.getInstance();

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayer player;
        ItemStack stack;
        if (NaturesCompassOverlay.mc.player != null && NaturesCompassOverlay.mc.level != null && !NaturesCompassOverlay.mc.options.hideGui && !mc.getDebugOverlay().showDebugScreen() && (NaturesCompassOverlay.mc.screen == null || ((Boolean)ConfigHandler.CLIENT.displayWithChatOpen.get()).booleanValue() && NaturesCompassOverlay.mc.screen instanceof ChatScreen) && (stack = ItemUtils.getHeldNatureCompass((Player)(player = NaturesCompassOverlay.mc.player))) != null && stack.getItem() instanceof NaturesCompassItem) {
            NaturesCompassItem compass = (NaturesCompassItem)stack.getItem();
            if (compass.getState(stack) == CompassState.SEARCHING) {
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.searching", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.biome", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, BiomeUtils.getBiomeName((Level)NaturesCompassOverlay.mc.level, compass.getBiomeKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
            } else if (compass.getState(stack) == CompassState.FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.found", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.biome", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, BiomeUtils.getBiomeName((Level)NaturesCompassOverlay.mc.level, compass.getBiomeKey(stack)), 5, 5, 0xAAAAAA, 4);
                if (compass.shouldDisplayCoordinates(stack)) {
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.coordinates", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, compass.getFoundBiomeX(stack) + ", " + compass.getFoundBiomeZ(stack), 5, 5, 0xAAAAAA, 7);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.distance", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 9);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, String.valueOf(BiomeUtils.getDistanceToBiome((Player)player, compass.getFoundBiomeX(stack), compass.getFoundBiomeZ(stack))), 5, 5, 0xAAAAAA, 10);
                }
            } else if (compass.getState(stack) == CompassState.NOT_FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.notFound", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.biome", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, BiomeUtils.getBiomeName((Level)NaturesCompassOverlay.mc.level, compass.getBiomeKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.naturescompass.samples", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 9);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, String.valueOf(compass.getSamples(stack)), 5, 5, 0xAAAAAA, 10);
            }
        }
    }
}

